using UnityEngine;
using System.Collections;

public enum playerState{IDLE, ROWING, FIGHTING, SWIMMING};

public class Player : MonoBehaviour 
{	
	public int playerNumber = 1;
	public int currentCanoo = 1;
	private int hp = 100;
	public int state = (int)playerState.IDLE;
	public int money = 0;
	private Vector3 speed = new Vector3(0.1f, 0, 0);
	private bool topPosition = true;
	private float timeAtLeave = 0.0f;
	private bool colliderRdy = false;
	public GameObject canoo1;
	public GameObject canoo2;
	public bool didLoseFight = false;
	
	// Use this for initialization
	void Start () {
		collider.enabled = false;
		if(playerNumber == 2 || playerNumber == 4)
			topPosition = false;
	}
	
	void updateSwimming(){
		transform.position -= new Vector3(0, 0.03f, 0);
		if(transform.position.y < -9.70f){
			transform.position = new Vector3(transform.position.x, 
			                                            20, transform.position.z);
		}
		if(Time.time - timeAtLeave > 2.5f && colliderRdy){
			colliderRdy = false;
			collider.enabled = true;
		}
		if(((Input.GetKey(KeyCode.Q) && playerNumber == 1) || 
		   (Input.GetKey(KeyCode.V) && playerNumber == 2) ||
			(Input.GetKey(KeyCode.I) && playerNumber == 3) ||
				(Input.GetKey(KeyCode.DownArrow) && playerNumber == 4)) &&
		   		transform.position.x >= -3.5) // Should be changed to the correct control, depending on playerNumber
		   transform.position -= new Vector3(0.03f, 0, 0);
		else if(((Input.GetKey(KeyCode.W) && playerNumber == 1) || 
		   (Input.GetKey(KeyCode.B) && playerNumber == 2) ||
			(Input.GetKey(KeyCode.O) && playerNumber == 3) ||
				(Input.GetKey(KeyCode.RightArrow) && playerNumber == 4)) &&
		   		transform.position.x <= 3.5)
		   transform.position += new Vector3(0.03f, 0, 0);
		
		
	}
	
	public void lostFight(){
		didLoseFight = true;
		abandonShip(false);
	}
	
	public void abandonShip(bool fromShip){
		if(fromShip || didLoseFight){
			if(!fromShip){
				Canoo1 canooScript;
				if(currentCanoo == 1)
					canooScript = canoo1.GetComponent("Canoo1") as Canoo1;
				else
					canooScript = canoo2.GetComponent("Canoo1") as Canoo1;
				canooScript.popPlayerAboard(playerNumber);
			}
			currentCanoo = 0;
			state = (int)playerState.SWIMMING;
			timeAtLeave = Time.time;
			colliderRdy = true;
			didLoseFight = false;
		}
	}
	
	// Update is called once per frame
	void Update () {
		Canoo1 canooScript;
		if(currentCanoo == 1)
			canooScript = canoo1.GetComponent("Canoo1") as Canoo1;
		else
			canooScript = canoo2.GetComponent("Canoo1") as Canoo1;
		switch(state){
		case (int)playerState.IDLE:
			if(currentCanoo == 1){
				if(canooScript.isTop(playerNumber))
			   		transform.position = canoo1.transform.position + new Vector3(0, 0.4f, -0.01f);
				else
					transform.position = canoo1.transform.position - new Vector3(0, 0.1f, 0.01f);
			}
			else if(currentCanoo == 2){
				if(canooScript.isTop(playerNumber))
			   		transform.position = canoo2.transform.position + new Vector3(0, 0.4f, -0.01f);
				else
					transform.position = canoo2.transform.position - new Vector3(0, 0.1f, 0.01f);
			}
			abandonShip(false);
			break;
		case (int)playerState.ROWING:
			if(currentCanoo == 1){
				if(canooScript.isTop(playerNumber))
			   		transform.position = canoo1.transform.position + new Vector3(0, 0.4f, -0.01f);
				else
					transform.position = canoo1.transform.position - new Vector3(0, 0.1f, 0.01f);
			}
			else if(currentCanoo == 2){
				if(canooScript.isTop(playerNumber))
			   		transform.position = canoo2.transform.position + new Vector3(0, 0.4f, -0.01f);
				else
					transform.position = canoo2.transform.position - new Vector3(0, 0.1f, 0.01f);
			}
			abandonShip(false);
			break;
		case (int)playerState.FIGHTING:
			break;
		case (int)playerState.SWIMMING:
			updateSwimming();
			break;
		}
	}
}
